//--------------------------------------------------------------------------------------
// File:		Rect.h.
// Namespace:	Global.
// Description:	A rectangle class.
// Author:		Grant Davies.
// Platform:	ALL.
// 
//--------------------------------------------------------------------------------------

#ifndef __RECT__
#define __RECT__


//--------------------------------------------------------------------------------------
// Includes.
//--------------------------------------------------------------------------------------



//--------------------------------------------------------------------------------------
// Constants.
//--------------------------------------------------------------------------------------

#define CLASS_NAME Rect


//--------------------------------------------------------------------------------------
// Data Types.
//--------------------------------------------------------------------------------------

//--------------------------------------------------------------------------------------
// Type name:	Rect.
// Description:	A rectangle class.
//--------------------------------------------------------------------------------------

class Rect
{
public:

	//--------------------------------------------------------------------------------------
	// Public Member Functions.
	//--------------------------------------------------------------------------------------


	Rect();
	Rect(int x, int y, int w, int h);

	bool canAccomodateRect(const Rect& otherRect) const;
	int getArea() const;
	void increaseDimensions(int x, int y);
	void increaseDimensionsToPowerOf2(int x = 0, int y = 0);

	//--------------------------------------------------------------------------------------
	// Public Data Members.
	//--------------------------------------------------------------------------------------

	int x;
	int y;
	int w;
	int h;
};

//--------------------------------------------------------------------------------------
// Function Definitions.
//--------------------------------------------------------------------------------------


#undef CLASS_NAME


#endif //__RECT__
