//--------------------------------------------------------------------------------------
// File:		Rect.cpp.
// Namespace:	Global.
// Description:	A rectangle class.
// Author:		Grant Davies.
// Platform:	ALL.
// 
//--------------------------------------------------------------------------------------

//--------------------------------------------------------------------------------------
// Includes.
//--------------------------------------------------------------------------------------

#ifndef __RECT__
#include "Rect.h"
#endif //__RECT__

#ifndef __CORE__
#include "Core.h"
#endif //__CORE__


//--------------------------------------------------------------------------------------
// Constants.
//--------------------------------------------------------------------------------------

#define CLASS_NAME Rect


//--------------------------------------------------------------------------------------
// Function Definitions.
//--------------------------------------------------------------------------------------

//--------------------------------------------------------------------------------------
// Description:	Constructor.
// Parameters:	None.
// Returns:		None.
//--------------------------------------------------------------------------------------
Rect::Rect() : 
	x(0),
	y(0),
	w(0),
	h(0)
{
}

//--------------------------------------------------------------------------------------
// Description:	Constructor accepting dimensions of this rectangle.
// Parameters:	The x position of this rectangle,
//				The y position of this rectangle,
//				The width of this rectangle,
//				The height of this rectangle.
// Returns:		None.
//--------------------------------------------------------------------------------------
Rect::Rect(int x, int y, int w, int h) : 
	x(x),
	y(y),
	w(w),
	h(h)
{
}

//--------------------------------------------------------------------------------------
// Description:	Determine whether this rectangle can accomodate another rectangle.
// Parameters:	The other rectangle to accomodate.
// Returns:		true if this rectangle can accomodate the other rectangle; false if it
//				cannot.
//--------------------------------------------------------------------------------------
bool Rect::canAccomodateRect(const Rect& otherRect) const
{
	return (otherRect.w <= self.w && otherRect.h <= self.h);
}

//--------------------------------------------------------------------------------------
// Description:	Get the area of this rectangle.
// Parameters:	None.
// Returns:		The area of this rectangle.
//--------------------------------------------------------------------------------------
int Rect::getArea() const
{
	return self.w * self.h;
}

//--------------------------------------------------------------------------------------
// Description:	Increase the dimensions of this rectangle.
// Parameters:	The amount to increase the width,
//				The amount to increase the height.
// Returns:		None.
//--------------------------------------------------------------------------------------
void Rect::increaseDimensions(int x, int y)
{
	self.w += x;
	self.h += y;
}

//--------------------------------------------------------------------------------------
// Description:	Increase the dimensions of this rectangle to a power of 2 boundary.
// Parameters:	None.
// Returns:		None.
//--------------------------------------------------------------------------------------
void Rect::increaseDimensionsToPowerOf2(int x, int y)
{
	if (self.w > 0)
	{
		self.w += x;
		int nWidth = 1;
		while (nWidth < self.w)
		{
			nWidth <<= 1;
		}
		self.w = nWidth;
	}

	if (self.h > 0)
	{
		self.h += y;
		int nHeight = 1;
		while (nHeight < self.h)
		{
			nHeight <<= 1;
		}
		self.h = nHeight;
	}
}
