//--------------------------------------------------------------------------------------
// File:		Main.cpp.
// Namespace:	Global.
// Description:	Windows font to Doom 3 font converter.
// Author:		Grant Davies.
// Platform:	ALL.
// 
//--------------------------------------------------------------------------------------

//--------------------------------------------------------------------------------------
// Includes.
//--------------------------------------------------------------------------------------

#ifndef __FONTEXPORTER__
#include "FontExporter.h"
#endif //__FONTEXPORTER__


//--------------------------------------------------------------------------------------
// Constants.
//--------------------------------------------------------------------------------------


//--------------------------------------------------------------------------------------
// Function Definitions.
//--------------------------------------------------------------------------------------

//--------------------------------------------------------------------------------------
// Description:	Program entry point.
// Parameters:	The number of arguments passed to this program,
//				The array of arguments passed to this program.
// Returns:		Zero on success; non-zero on error.
//--------------------------------------------------------------------------------------
int main(int argumentCount, char* arguments[])
{
	FontExporter exporter;

	// Initialise the font exporter.
	bool okay = exporter.initialise(argumentCount, arguments);
	if (okay)
	{
		// Export the font.
		okay = exporter.export();
	}

	// Return zero on success, false on error.
	return okay ? 0 : -1;
}
