//--------------------------------------------------------------------------------------
// File:		glyph.h.
// Namespace:	Global.
// Description:	A wrapper for a FreeType glyph.
// Author:		Grant Davies.
// Platform:	ALL.
// 
//--------------------------------------------------------------------------------------

#ifndef __GLYPH__
#define __GLYPH__

//--------------------------------------------------------------------------------------
// Includes.
//--------------------------------------------------------------------------------------

#include <string>

#include <ft2build.h>
#include FT_FREETYPE_H

#include <il\il_wrap.h>

#ifndef __FREETYPEOBJECT__
#include "FreeTypeObject.h"
#endif //__FREETYPEOBJECT__

#ifndef __TYPES__
#include "Types.h"
#endif //__TYPES__

#ifndef __RECT__
#include "Rect.h"
#endif //__RECT__


//--------------------------------------------------------------------------------------
// Constants.
//--------------------------------------------------------------------------------------

#define CLASS_NAME Glyph


//--------------------------------------------------------------------------------------
// Data Types.
//--------------------------------------------------------------------------------------


//--------------------------------------------------------------------------------------
// Type name:	Glyph.
// Description:	A wrapper for a FreeType glyph.
//--------------------------------------------------------------------------------------

class Glyph : public FreeTypeObject
{
public:

	//--------------------------------------------------------------------------------------
	// Public types.
	//--------------------------------------------------------------------------------------

	enum XOffsetFixType
	{
		XOffsetFixType_None,
		XOffsetFixType_Glyph,
		XOffsetFixType_Font
	};

	//--------------------------------------------------------------------------------------
	// Public methods.
	//--------------------------------------------------------------------------------------

	Glyph(
		const FT_Face& typeFace,
		int glyphIndex,
		XOffsetFixType xOffsetFixType = XOffsetFixType_None,
		int xPadding = 0);
	~Glyph();

	void blitToSurface(ilImage* surface, int xPosition, int yPosition) const;

	float getXAdvance() const;
	float getYAdvance() const;

	int getWidth() const;
	int getHeight() const;

	int getBitmapLeft() const;
	int getBitmapTop() const;

	void writeToFile(std::string fileName);

	Rect getRect() const;

private:

	//--------------------------------------------------------------------------------------
	// Private methods.
	//--------------------------------------------------------------------------------------

	void createSurfaceFromGlyph(XOffsetFixType xOffsetFixType, int xPadding);

	//--------------------------------------------------------------------------------------
	// Private data.
	//--------------------------------------------------------------------------------------

	FT_GlyphSlot glyph;
	ilImage* surface;
	int width;
	int height;
};


//--------------------------------------------------------------------------------------
// Function Definitions.
//--------------------------------------------------------------------------------------


#undef CLASS_NAME


#endif //__GLYPH__
