//--------------------------------------------------------------------------------------
// File:		FreeTypeObject.cpp.
// Namespace:	Global.
// Description:	
// Author:		Grant Davies.
// Platform:	ALL.
// 
//--------------------------------------------------------------------------------------

//--------------------------------------------------------------------------------------
// Includes.
//--------------------------------------------------------------------------------------

#ifndef __FREETYPEOBJECT__
#include "FreeTypeObject.h"
#endif //__FREETYPEOBJECT__

#ifndef __CORE__
#include "Core.h"
#endif //__CORE__


//--------------------------------------------------------------------------------------
// Constants.
//--------------------------------------------------------------------------------------

#define CLASS_NAME FreeTypeObject


//--------------------------------------------------------------------------------------
// Function Definitions.
//--------------------------------------------------------------------------------------

//--------------------------------------------------------------------------------------
// Description:	Constructor.
// Parameters:	None.
// Returns:		None.
//--------------------------------------------------------------------------------------
FreeTypeObject::FreeTypeObject() :
	lastErrorValue(0)
{
}

//--------------------------------------------------------------------------------------
// Description:	Get the error value of the last operation.
// Parameters:	None.
// Returns:		The error value of the last operation.
//--------------------------------------------------------------------------------------
int FreeTypeObject::getLastErrorValue() const
{
	return self.lastErrorValue;
}

//--------------------------------------------------------------------------------------
// Description:	Determine whether the status of this object is okay.
// Parameters:	None.
// Returns:		true if the status of this object is okay (i.e. no errors); false if
//				the current status of this object is in error.
//--------------------------------------------------------------------------------------
bool FreeTypeObject::isStatusOk() const
{
	return (0 == self.lastErrorValue);
}

//--------------------------------------------------------------------------------------
// Description:	Determine whether the status of this object is in error.
// Parameters:	None.
// Returns:		true if the status of this object is in error; false if the current 
//				status of this object is okay (i.e. no errors).
//--------------------------------------------------------------------------------------
bool FreeTypeObject::isStatusError() const
{
	return !self.isStatusOk();
}
