//--------------------------------------------------------------------------------------
// File:		FontEngine.h.
// Namespace:	Global.
// Description:	A wrapper for the FreeType font engine.
// Author:		Grant Davies.
// Platform:	ALL.
// 
//--------------------------------------------------------------------------------------

#ifndef __FONTENGINE__
#define __FONTENGINE__

//--------------------------------------------------------------------------------------
// Includes.
//--------------------------------------------------------------------------------------

#include <string>

#include <ft2build.h>
#include FT_FREETYPE_H

#ifndef __FREETYPEOBJECT__
#include "FreeTypeObject.h"
#endif //__FREETYPEOBJECT__

#ifndef __FONT__
#include "Font.h"
#endif //__FONT__


//--------------------------------------------------------------------------------------
// Constants.
//--------------------------------------------------------------------------------------

#define CLASS_NAME FontEngine


//--------------------------------------------------------------------------------------
// Data Types.
//--------------------------------------------------------------------------------------

//--------------------------------------------------------------------------------------
// Type name:	FontEngine.
// Description:	A wrapper for the FreeType font engine.
//--------------------------------------------------------------------------------------

class FontEngine : public FreeTypeObject
{
public:

	//--------------------------------------------------------------------------------------
	// Public methods.
	//--------------------------------------------------------------------------------------

	FontEngine();

	bool initialise();

	Font* loadFont(std::string strFontFace);

private:

	//--------------------------------------------------------------------------------------
	// Private data.
	//--------------------------------------------------------------------------------------

	// The FreeType library.
	FT_Library freeTypeLibrary;

	// Whether or not this engine has been initialised yet or not.
	bool initialised;
};


//--------------------------------------------------------------------------------------
// Function Definitions.
//--------------------------------------------------------------------------------------


#undef CLASS_NAME


#endif //__FONTENGINE__
