//--------------------------------------------------------------------------------------
// File:		DescriptorFile.h.
// Namespace:	Global.
// Description:	
// Author:		Grant Davies.
// Platform:	ALL.
// 
//--------------------------------------------------------------------------------------

#ifndef __DESCRIPTORFILE__
#define __DESCRIPTORFILE__


//--------------------------------------------------------------------------------------
// Includes.
//--------------------------------------------------------------------------------------

#include <string>
#include <fstream>

#ifndef __DOOM3GLYPHDESCRIPTOR__
#include "Doom3GlyphDescriptor.h"
#endif //__DOOM3GLYPHDESCRIPTOR__


//--------------------------------------------------------------------------------------
// Constants.
//--------------------------------------------------------------------------------------

#define CLASS_NAME DescriptorFile


//--------------------------------------------------------------------------------------
// Data Types.
//--------------------------------------------------------------------------------------

//--------------------------------------------------------------------------------------
// Type name:	DescriptorFile.
// Description:	
//--------------------------------------------------------------------------------------

class DescriptorFile
{
public:

	//--------------------------------------------------------------------------------------
	// Public Types.
	//--------------------------------------------------------------------------------------

	enum Mode
	{
		Mode_Binary,
		Mode_Text
	};

	//--------------------------------------------------------------------------------------
	// Public Member Functions.
	//--------------------------------------------------------------------------------------

	~DescriptorFile();

	void open(std::string fileName, Mode mode);
	void close();

	void writeGlyphDescriptor(const Doom3GlyphDescriptor& glyphDescriptor);
	void writeTrailer(float glyphScale, std::string name);

private:

	//--------------------------------------------------------------------------------------
	// Private Member Functions.
	//--------------------------------------------------------------------------------------

	void writeString(std::string name, std::string value, int maxSize);
	void writeFloat(std::string name, float value);
	void writeInteger(std::string name, int value);

	//--------------------------------------------------------------------------------------
	// Private Data Members.
	//--------------------------------------------------------------------------------------

	std::ofstream stream;
	Mode mode;
};


//--------------------------------------------------------------------------------------
// Function Definitions.
//--------------------------------------------------------------------------------------


#undef CLASS_NAME


#endif //__DESCRIPTORFILE__
